

COMMENT: Replication of Chapter 7,Table 3 Explanatory Models
COMMENT: These runs use the 10-point Corrupt scale as a covariate except for the model that classifies the regions by
the four category coruptyp typology.
COMMENT: This syntax is copyright by Robert B. Smith,  2011.

DATASET ACTIVATE DataSet1.

WEIGHT
  OFF.

COMMENT: Replication of Chapter 7, Table 3, Intercepts Only Model 1.
MIXED
  HDIRANK 
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE)
 LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
  /RANDOM INTERCEPT  | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT = Sqrtpop 
  /EMMEANS = TABLES(Overall).

COMMENT: Replication of Chapter 7, Table 3 , Full Descriptive Model 2.
DATASET ACTIVATE DataSet1.
MIXED HDIRANK BY CULTURE SLAVE98 FRETYP99 DEBT CONFLICT with CORRUPT
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE SLAVE98 FRETYP99 DEBT CONFLICT CORRUPT| SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(FRETYP99) COMPARE ADJ(LSD)
  /EMMEANS=TABLES(SLAVE98) COMPARE ADJ(LSD).

COMMENT: Replication of Chapter 7, Table 2,  Model 3 with Region Classified by Culture, HDI Rank.
MIXED
  HDIRank BY culture slave98 Fretyp99 debt conflict with corrupt
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED =  culture slave98 Fretyp99 debt conflict corrupt| SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
  /RANDOM INTERCEPT  | SUBJECT(REGION*culture) COVTYPE(VC)
  /REGWGT = Sqrtpop  
  /EMMEANS = TABLES(Slave98) COMPARE ADJ(LSD)
  /EMMEANS = TABLES(Fretyp99) COMPARE ADJ(LSD)  .

COMMENT: Replication of Chapter 7, Table 3, Model 4 with Region classified by Slavery typology, HDI Rank.
MIXED
  HDIRANK  BY CULTURE Slave98 Fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 Fretyp99 debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*slave98) COVTYPE(VC)
  /REGWGT = Sqrtpop.
 

COMMENT: Replication of Chapter 7, Table 3, Model 5 with Region classified by three category Freedom, HDI Rank.
MIXED
  HDIRANK  BY CULTURE slave98 fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 fretyp99 debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*fretyp99) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Table 3, Model 6 with Region classified by two category Freedom, HDI Rank.
MIXED
  HDIRANK  BY CULTURE slave98 fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 fretyp99 debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*dichofre) COVTYPE(VC)
  /REGWGT = Sqrtpop.



COMMENT: Replication of Chapter 7, Table 2, Model 7 with Region classified by Debt, HDI Rank.
MIXED
  HDIRANK  BY CULTURE slave98 Fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 Fretyp99 Debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*Debt) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Table 2, Model 8 With Region Classified by Conflict, HDIRank.
MIXED
  HDIRANK  BY CULTURE slave98 Fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 Fretyp99 debt Conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*CONFLICT) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Table 2, Model 9 With Region Classified by Coruptyp, HDI RANK.
MIXED
  HDIRANK  BY CULTURE slave98 Fretyp99 Debt Conflict Coruptyp
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 Fretyp99 debt conflict Coruptyp | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*Coruptyp) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Footnote Table 3, Model 4a dichotomous slavary is factor, four category slavary is classifier.
 with Region classified by four-category slavery, HDI Rank.
MIXED
  HDIRANK  BY CULTURE emancip Fretyp99 Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture emancip Fretyp99 debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*Slave98) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Footnote Table 3, Model 2b Full descriptive, dichotomous freedom is factor.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT = Sqrtpop.


COMMENT: Replication of Chapter 7, Footnote Table 3, Model 4b, dichotomous freedom is factor, Slavary is classification.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*Slave98) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Footnote Table 3, Model 5b  dichotomous freedom is factor and three-category is classifier.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*fretyp99) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Footnote Table 3, Model 6b, dichotomous freedom is factor and classifier.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*dichofre) COVTYPE(VC)
  /REGWGT = Sqrtpop.


COMMENT: Replication of Chapter 7, Footnote Table 3, Model7b, dichotomous freedom is factor and dept is classifier.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*debt) COVTYPE(VC)
  /REGWGT = Sqrtpop.


COMMENT: Replication of Chapter 7, Footnote Table 3, Model8b, dichotomous freedom is factor and conflict is classifier.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*conflict) COVTYPE(VC)
  /REGWGT = Sqrtpop.

COMMENT: Replication of Chapter 7, Footnote Table 3, Model extra, dichotomous freedom is factor and conflict is classifier.
MIXED
  HDIRANK  BY CULTURE Slave98 DichoFre Debt Conflict with CORRUPT
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = Culture slave98 dichofre debt conflict CORRUPT  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(REGION*coruptyp) COVTYPE(VC)
  /REGWGT = Sqrtpop.



